/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_403;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.peripheral.alternate_dimension.AlternateDimensions;
import qouteall.imm_ptl.peripheral.dim_stack.DimEntryWidget;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackGuiModel;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackScreen;
import qouteall.q_misc_util.Helper;

public class DimStackGuiController {
    private static final int entryCountLimit = 64;
    private final class_437 parentScreen;
    public final DimStackGuiModel model;
    public final DimStackScreen view;
    private boolean hasConflict = false;
    private final Supplier<List<class_5321<class_1937>>> dimensionListSupplier;
    private final Consumer<DimStackInfo> finishCallback;

    public DimStackGuiController(class_437 parentScreen, Supplier<List<class_5321<class_1937>>> dimensionListSupplier, Consumer<DimStackInfo> finishCallback) {
        this.parentScreen = parentScreen;
        this.model = new DimStackGuiModel();
        this.view = new DimStackScreen(parentScreen, this);
        this.dimensionListSupplier = dimensionListSupplier;
        this.finishCallback = finishCallback;
    }

    public void setEnabled(boolean enabled) {
        this.model.isEnabled = enabled;
        this.view.setEnabled(enabled);
        this.updateViewState();
    }

    private void updateViewState() {
        this.hasConflict = false;
        if (!this.model.isEnabled) {
            return;
        }
        Map<DimStackInfo.PortalInfo, List<DimStackEntry>> portalInfoMap = this.model.dimStackInfo.getPortalInfoMap();
        for (int i = 0; i < this.view.dimListWidget.method_25396().size(); ++i) {
            boolean conflictsToNext;
            int floorConnectionCount;
            DimEntryWidget widget = (DimEntryWidget)((Object)this.view.dimListWidget.method_25396().get(i));
            widget.entryIndex = i;
            List<DimStackEntry> ceilEntries = portalInfoMap.get(new DimStackInfo.PortalInfo(widget.dimension, VerticalConnectingPortal.ConnectorType.ceil));
            int ceilConnectionCount = ceilEntries == null ? 0 : ceilEntries.size();
            List<DimStackEntry> floorEntries = portalInfoMap.get(new DimStackInfo.PortalInfo(widget.dimension, VerticalConnectingPortal.ConnectorType.floor));
            int n = floorConnectionCount = floorEntries == null ? 0 : floorEntries.size();
            assert (widget.entry != null);
            int toPreviousConnectionCount = widget.entry.flipped ? floorConnectionCount : ceilConnectionCount;
            int toNextConnectionCount = widget.entry.flipped ? ceilConnectionCount : floorConnectionCount;
            boolean conflictsToPrevious = toPreviousConnectionCount > 1;
            boolean bl = conflictsToNext = toNextConnectionCount > 1;
            DimEntryWidget.ArrowType arrowType = this.model.dimStackInfo.isEffectivelyConnectingPrevious(i) ? (conflictsToPrevious ? DimEntryWidget.ArrowType.conflicting : DimEntryWidget.ArrowType.enabled) : (widget.arrowToPrevious = DimEntryWidget.ArrowType.none);
            DimEntryWidget.ArrowType arrowType2 = this.model.dimStackInfo.isEffectivelyConnectionNext(i) ? (conflictsToNext ? DimEntryWidget.ArrowType.conflicting : DimEntryWidget.ArrowType.enabled) : (widget.arrowToNext = DimEntryWidget.ArrowType.none);
            if (widget.arrowToPrevious != DimEntryWidget.ArrowType.conflicting && widget.arrowToNext != DimEntryWidget.ArrowType.conflicting) continue;
            this.hasConflict = true;
        }
    }

    public boolean addEntry(int index, DimStackEntry entry) {
        if (this.model.dimStackInfo.entries.size() >= 64) {
            return false;
        }
        Validate.isTrue((index >= 0 && index <= this.model.dimStackInfo.entries.size() ? 1 : 0) != 0);
        this.model.dimStackInfo.entries.add(index, entry);
        this.view.dimListWidget.method_25396().add(index, this.view.createDimEntryWidget(entry));
        this.updateViewState();
        return true;
    }

    public void batchAddEntries(int index, List<DimStackEntry> entries) {
        Validate.isTrue((index >= 0 && index <= this.model.dimStackInfo.entries.size() ? 1 : 0) != 0);
        List<DimStackEntry> entriesToAdd = entries;
        if (this.model.dimStackInfo.entries.size() + entries.size() > 64) {
            entriesToAdd = entries.subList(0, 64 - this.model.dimStackInfo.entries.size());
        }
        int currentIndex = index;
        for (DimStackEntry entry : entriesToAdd) {
            this.model.dimStackInfo.entries.add(currentIndex, entry);
            this.view.dimListWidget.method_25396().add(currentIndex, this.view.createDimEntryWidget(entry));
            ++currentIndex;
        }
        this.updateViewState();
    }

    public void removeEntry(int index) {
        Validate.isTrue((index >= 0 && index < this.model.dimStackInfo.entries.size() ? 1 : 0) != 0);
        this.model.dimStackInfo.entries.remove(index);
        this.view.dimListWidget.method_25396().remove(index);
        this.updateViewState();
    }

    public void clear() {
        this.model.dimStackInfo.entries.clear();
        this.view.dimListWidget.method_25396().clear();
        this.updateViewState();
    }

    public void editEntry(int index, DimStackEntry newEntry) {
        Validate.isTrue((index >= 0 && index < this.model.dimStackInfo.entries.size() ? 1 : 0) != 0);
        this.model.dimStackInfo.entries.set(index, newEntry);
        for (DimStackEntry entry : this.model.dimStackInfo.entries) {
            if (!entry.dimensionIdStr.equals(newEntry.dimensionIdStr)) continue;
            entry.bedrockReplacementStr = newEntry.bedrockReplacementStr;
        }
        DimEntryWidget newWidget = this.view.createDimEntryWidget(newEntry);
        this.view.dimListWidget.method_25396().set(index, newWidget);
        this.view.dimListWidget.method_25313((class_350.class_351)newWidget);
        this.updateViewState();
    }

    public void onDragged(int selected, int mouseOver) {
        Validate.isTrue((selected >= 0 && selected < this.model.dimStackInfo.entries.size() ? 1 : 0) != 0);
        Validate.isTrue((mouseOver >= 0 && mouseOver < this.model.dimStackInfo.entries.size() ? 1 : 0) != 0);
        Helper.swapListElement(this.model.dimStackInfo.entries, selected, mouseOver);
        Helper.swapListElement(this.view.dimListWidget.method_25396(), selected, mouseOver);
        this.updateViewState();
        this.view.dimListWidget.method_25313((class_350.class_351)((DimEntryWidget)((Object)this.view.dimListWidget.method_25396().get(mouseOver))));
    }

    public void initializeAsDefault() {
        DimStackInfo preset = DimStackManagement.getDimStackPreset();
        if (preset != null) {
            this.setEnabled(true);
            this.setLoopEnabled(preset.loop);
            this.setGravityTransformEnabled(preset.gravityTransform);
            this.batchAddEntries(0, preset.entries);
        } else {
            this.setEnabled(false);
            this.setLoopEnabled(false);
            this.setGravityTransformEnabled(false);
            ArrayList<DimStackEntry> entriesToAdd = new ArrayList<DimStackEntry>();
            entriesToAdd.add(new DimStackEntry(AlternateDimensions.BRIGHT_VOID));
            entriesToAdd.add(new DimStackEntry(AlternateDimensions.BRIGHT_SKYLAND));
            entriesToAdd.add(new DimStackEntry((class_5321<class_1937>)class_1937.field_25179));
            entriesToAdd.add(new DimStackEntry((class_5321<class_1937>)class_1937.field_25180));
            this.batchAddEntries(0, entriesToAdd);
        }
    }

    public List<class_5321<class_1937>> getDimensionList() {
        return this.dimensionListSupplier.get();
    }

    public void onFinish() {
        if (this.hasConflict) {
            this.showConflictingAlert();
        } else {
            this.finishCallback.accept(this.model.getResult());
        }
    }

    private void showConflictingAlert() {
        class_310.method_1551().method_1507((class_437)new class_403(() -> class_310.method_1551().method_1507((class_437)this.view), (class_2561)class_2561.method_43471((String)"imm_ptl.conflicting_dim_stack").method_27692(class_124.field_1061), (class_2561)class_2561.method_43471((String)"imm_ptl.conflicting_dim_stack_detail")));
    }

    public void toggleEnabled() {
        this.setEnabled(!this.model.isEnabled);
    }

    public void toggleLoop() {
        boolean cond = !this.model.dimStackInfo.loop;
        this.setLoopEnabled(cond);
    }

    public void setLoopEnabled(boolean cond) {
        this.model.dimStackInfo.loop = cond;
        this.view.setLoopEnabled(this.model.dimStackInfo.loop);
        this.updateViewState();
    }

    public void toggleGravityMode() {
        boolean cond = !this.model.dimStackInfo.gravityTransform;
        this.setGravityTransformEnabled(cond);
    }

    public void setGravityTransformEnabled(boolean cond) {
        this.model.dimStackInfo.gravityTransform = cond;
        this.view.setGravityTransformEnabled(this.model.dimStackInfo.gravityTransform);
    }

    public void setAsDefault() {
        if (this.hasConflict) {
            this.showConflictingAlert();
        } else {
            DimStackManagement.setDimStackPreset(this.model.getResult());
            class_310.method_1551().method_1507((class_437)new class_403(() -> class_310.method_1551().method_1507((class_437)this.view), (class_2561)class_2561.method_43470((String)""), (class_2561)class_2561.method_43471((String)"imm_ptl.dim_stack_default_updated")));
        }
    }
}

